﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    /// <summary>
    /// Deserialize Consults step.
    /// </summary>
    public class SerializeConsultsStep : FilterBase<GetConsultsStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetConsultsStateObject state)
        {
            try
            {
                state.SerializedRequestMessage = PipelineUtilities.SerializeInstance(state.RequestMessage);
                Logger.Instance.Info(string.Format("INFO: HealthShare Get Consult Data: {0}", state.SerializedRequestMessage));
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Get Consults SerializeConsultStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}